function [QMatrix] = MakeQMatrix_mutant(par, Calcium, DN_IO)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%                                                                                 %%%
%%%               This code was written to be used in our publication               %%%
%%%             "Allosteric stabilization of calcium and lipid binding              %%%
%%%                    three synaptotagmins in fast exocytosis"                     %%% 
%%%                          Kobbersmed et al., Journal Year                        %%%
%%%                           DOI:  XX.XXXX/XXXX.XXXXXXXXXX                         %%%
%%%                                                                                 %%%
%%%             When reusing this code in a publication, in original or             %%%
%%%                       modified form, please cite our work.                      %%%
%%%                                                                                 %%%
%%%                                     Authors:                                    %%%
%%%                   Janus R. L. Kobbersmed (januslind@math.ku.dk)                 %%%
%%%                    Manon M.M. Berns (manon.berns@sund.ku.dk)                    %%%
%%%                    Alexander M. Walter (awalter@sund.ku.dk)                     %%%
%%%         Department of neuroscience, University of Copenhagen, Denmark           %%%
%%%                                    October 2021                                 %%%
%%%                                                                                 %%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%This script computes the intensity matrix in the PIP2-synaptotagmin
%%%model based on the parameter vector and the calcium concentration.

%Input
%par- parameters (following order par_int in gillespie algorithm
%Ca - calcium concentration
%DN_IO - 0 for not evaluating mutants, array with 4 values for evaluating
%mutants [fold change KDpip, Fold change KD ca, fold change konCa, A]

k_onCa = par(1);
KD_Ca = par(2);
k_onPIP2 = par(3);
PIP2 = par(4);
c = par(5);

l_0 = par(6);
f = par(7);
nSyts = par(8);
k_DPIP2 = par(12);
CaCoop = par(10);
maxCross = par(9);

n_WT= par(11);
n_mut = nSyts - n_WT;

maxCross1 = maxCross;  %can be viewed as the total number of slots
if maxCross > nSyts
    maxCross = nSyts;
end


if DN_IO
    c_mut = DN_IO(4);
    k_onCa_mut = k_onCa * DN_IO(3);
    k_DCa_mut = KD_Ca * DN_IO(2);
    k_onPIP_mut = k_onPIP2;
    k_DPIP_mut = k_DPIP2 * DN_IO(1);
else
    c_mut = c;
    k_onCa_mut = k_onCa;
    k_DCa_mut = KD_Ca;
    k_onPIP_mut = k_onPIP2;
    k_DPIP_mut = k_DPIP2;
end



kalpha = k_onCa * Calcium^CaCoop;
kbeta = KD_Ca*k_onCa;
kgamma = PIP2 * k_onPIP2;
kdelta = k_DPIP2*k_onPIP2;

kalpha_mut = k_onCa_mut * Calcium^CaCoop;
kbeta_mut = k_DCa_mut*k_onCa_mut;
kgamma_mut = PIP2 * k_onPIP_mut;
kdelta_mut = k_DPIP_mut*k_onPIP_mut;



% nstates = indCal(nSyts, maxCross, maxCross, nSyts-maxCross, 0);

[indices] = indCal_all_mutant(n_WT, n_mut, maxCross);

nstates = max(indices(:));

QMatrix = zeros(nstates+1);

% nStatesCurPipCa = zeros(1,nSyts+1);

% for k = 0:nSyts %Counting number of different states with k Pip2--Ca associations
%     nStatesCurPipCa(k+1) = nchoosek(3+(nSyts-k)-1,(nSyts-k));
% end
% 
% indCal = @(comb,Ca,PIP)(sum(nStatesCurPipCa(1:comb))+sum(nSyts-comb-(0:(Ca-1))+1)+(PIP+1));%THIS FUNCTION FINDS THE INDEX OF A STATE GIVEN PIP--Ca, Ca, and PIP
% ind_test = 0
for k = 0:min(maxCross, n_WT) %PIPCa to WT
    for l = 0:min((maxCross-k),n_mut) %PIPCa to mut
        for m = 0:min((maxCross-k-l), n_WT-k) %PIP to WT
            for n = 0:min((maxCross-k-l-m), n_mut-l) %PIP to mut
                for p = 0:(n_WT-k-m) %Ca to WT
                    for q = 0:(n_mut-l-n) %Ca to mutant
%             ind_test = ind_test+1;
            curIndex = indices(k+1,l+1, m+1,n+1, p+1, q+1);
%             test(ind_test) = curIndex;
            
            if k > 0 %WT unbinding of Ca or PIP from Ca-PIP 
                QMatrix(curIndex, indices(k, l+1, m+2, n+1, p+1, q+1)) = k*c*kbeta; %Unbinding of Ca from PIPCa
                QMatrix(curIndex, indices(k, l+1, m+1, n+1, p+2, q+1)) = k*c*kdelta; %Unbinding of PIP from PIPCa
            end

            if l > 0 %mut unbinding of Ca or PIP from Ca-PIP 
                QMatrix(curIndex, indices(k+1, l, m+1,n+2, p+1, q+1)) = l*c_mut*kbeta_mut; %Unbinding of Ca from PIPCa
                QMatrix(curIndex, indices(k+1, l, m+1,n+1, p+1, q+2)) = l*c_mut*kdelta_mut; %Unbinding of PIP from PIPCa
            end
            
            if p > 0 %WT unbinding of single Ca
                QMatrix(curIndex, indices(k+1, l+1, m+1, n+1, p, q+1)) = p*kbeta;
            end
            
            if q > 0 %mut unbinding of single Ca
                QMatrix(curIndex, indices(k+1, l+1, m+1, n+1, p+1, q)) = q*kbeta_mut;
            end

            if m > 0 %WT Unbinding of single PIP
                QMatrix(curIndex, indices(k+1, l+1, m, n+1, p+1, q+1)) = m*kdelta;
            end

            if n > 0 %mut Unbinding of single PIP
                QMatrix(curIndex, indices(k+1, l+1, m+1, n, p+1, q+1)) = n*kdelta_mut;
            end
            
            if (k+l+m+n) < maxCross && p > 0 %WT Binding of PIP to Ca to form PIP-Ca
                QMatrix(curIndex, indices(k+2, l+1, m+1, n+1, p, q+1)) = (maxCross1-(k+n))*p*kgamma;
            end

            if (k+l+m+n) < maxCross && q > 0 %mut Binding of PIP to Ca to form PIP-Ca
                QMatrix(curIndex, indices(k+1, l+2, m+1, n+1, p+1, q)) = (maxCross1-(k+n))*q*kgamma_mut;
            end
            
            if  m > 0 %WT Binding of Ca to PIP to form PIP-Ca
                QMatrix(curIndex, indices(k+2, l+1, m, n+1, p+1, q+1)) = m*kalpha;
            end

            if  n > 0 %mut Binding of Ca to PIP to form PIP-Ca
                QMatrix(curIndex, indices(k+1, l+2, m+1, n, p+1, q+1)) = n*kalpha_mut;
            end
            
            if (k+m+p) < n_WT %WT binding of single Ca and single PIP
                QMatrix(curIndex, indices(k+1, l+1, m+1, n+1, p+2, q+1)) = (n_WT-k-m-p) * kalpha;
                if ((k+l+m+n) < maxCross)
                    QMatrix(curIndex, indices(k+1, l+1, m+2, n+1, p+1, q+1)) = (maxCross1-(k+l+m+n))*(n_WT-k-m-p) * kgamma;
                end
            end

            if (l+n+q) < n_mut %mut binding of single Ca and single PIP
                QMatrix(curIndex, indices(k+1, l+1, m+1, n+1, p+1, q+2)) = (n_mut-l-n-q) * kalpha_mut;
                if (k+l+m+n) < maxCross
                    QMatrix(curIndex, indices(k+1, l+1, m+1, n+2, p+1, q+1)) = (maxCross1-(k+l+m+n))*(n_mut-l-n-q) * kgamma_mut;
                end
            end
            
            QMatrix(curIndex, end) = l_0*f^(k+l);
            QMatrix(curIndex, curIndex) = - sum(QMatrix(curIndex,:));
        
                    end
                end
            end
        end
    end
end

% QMatrix = QMatrix';
